/*
 * Decompiled with CFR 0.152.
 */
package iaik.iso.iso9796;

import iaik.iso.iso9796.ISO9796P2ParameterSpec;
import iaik.iso.iso9796.RawISO9796P2ParameterSpec;
import iaik.security.md.SHA;
import iaik.security.random.SecRandom;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;

public abstract class ISO9796P2Signature
extends SignatureSpi {
    private static final BigInteger a = BigInteger.valueOf(12L);
    private static final BigInteger b = BigInteger.valueOf(16L);
    static HashMap c = new HashMap(10);
    protected MessageDigest hashEngine_;
    int d;
    byte e;
    boolean f;
    int g;
    int h;
    private BigInteger p;
    private BigInteger q;
    byte[] i;
    byte[] j;
    int k;
    int l;
    boolean m;
    boolean n;
    MessageDigest o;
    protected SecureRandom secureRandom_;

    static String a(byte by) {
        return (String)c.get(new Byte(by));
    }

    public static void registerHashEngine(byte by, String string) {
        c.put(new Byte(by), string);
    }

    public static int calculateCapacity(int n2, int n3, boolean bl) {
        int n4 = n2 - n3 - (bl ? 16 : 8) - 4;
        if (n4 < 7) {
            throw new IllegalArgumentException("Invalid capacity (" + n4 + "). Must be >= 7!");
        }
        return n4;
    }

    private static byte[] a(byte[] byArray, int n2) {
        if (byArray.length == n2) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        if (byArray.length > n2) {
            System.arraycopy(byArray, byArray.length - n2, byArray2, 0, n2);
        } else if (byArray.length < n2) {
            System.arraycopy(byArray, 0, byArray2, n2 - byArray.length, byArray.length);
        }
        return byArray2;
    }

    protected ISO9796P2Signature(String string) {
        this.hashEngine_ = new SHA();
        this.e = (byte)51;
        this.d = 20;
        this.f = true;
        this.m = false;
        this.o = null;
        this.n = true;
    }

    protected ISO9796P2Signature(String string, int n2, byte by) {
        this.e = by;
        this.d = n2;
        this.f = false;
        this.m = true;
        this.o = null;
        this.n = true;
    }

    protected void engineUpdate(byte by) {
        this.j = null;
        if (this.hashEngine_ == null && this.o == null) {
            throw new NullPointerException("MessageDigest engine must not be null!");
        }
        if (this.i == null) {
            this.b();
        }
        if (this.o == null) {
            this.hashEngine_.update(by);
            if (this.k < this.i.length) {
                this.i[this.k++] = by;
            }
            ++this.l;
        } else {
            this.o.update(by);
        }
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        this.j = null;
        if (this.hashEngine_ == null && this.o == null) {
            throw new NullPointerException("MessageDigest engine must not be null!");
        }
        if (this.i == null) {
            this.b();
        }
        if (this.o == null) {
            this.hashEngine_.update(byArray, n2, n3);
            if (this.k < this.i.length) {
                int n4 = Math.min(this.i.length - this.k, n3);
                System.arraycopy(byArray, n2, this.i, this.k, n4);
                this.k += n4;
            }
            this.l += n3;
        } else {
            this.o.update(byArray, n2, n3);
        }
    }

    void b() {
        if (this.h == 0) {
            throw new IllegalStateException("Engine not initialized. Missing modulus length!");
        }
        if (this.d <= 0) {
            String string = null;
            string = this.hashEngine_ != null ? this.hashEngine_.getAlgorithm() : this.o.getAlgorithm();
            this.d = Util.getDigestLength(string);
        }
        if (this.g == 0) {
            this.g = this.a();
        }
        this.i = new byte[this.g / 8];
    }

    int a() {
        return ISO9796P2Signature.calculateCapacity(this.h, this.d * 8, this.f);
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        this.j = null;
        try {
            if (!(object instanceof AlgorithmParameterSpec)) {
                throw new InvalidParameterException("value must be an instance of AlgorithmParameterSpec.");
            }
            this.engineSetParameter((AlgorithmParameterSpec)object);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException(invalidAlgorithmParameterException.getMessage());
        }
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof ISO9796P2ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Parameters must be a ISO9796P2ParameterSpec!");
        }
        this.j = null;
        ISO9796P2ParameterSpec iSO9796P2ParameterSpec = (ISO9796P2ParameterSpec)algorithmParameterSpec;
        MessageDigest messageDigest = iSO9796P2ParameterSpec.getHashEngine();
        if (messageDigest != null) {
            if (this.m) {
                if (!this.checkHashEngineName(messageDigest.getAlgorithm())) {
                    throw new InvalidAlgorithmParameterException("Invalid hash engine parameter (" + messageDigest.getAlgorithm() + "). Expected " + this.hashEngine_.getAlgorithm() + ".");
                }
                if (this.d != iSO9796P2ParameterSpec.getHashLen()) {
                    throw new InvalidAlgorithmParameterException("Invalid hash length parameter (" + iSO9796P2ParameterSpec.getHashLen() + "). Expected " + this.d + ".");
                }
            }
            this.hashEngine_ = messageDigest;
            this.d = iSO9796P2ParameterSpec.getHashLen();
        }
        if (iSO9796P2ParameterSpec.getHashID() > -1) {
            byte by = (byte)iSO9796P2ParameterSpec.getHashID();
            if (this.m && this.e != by) {
                throw new InvalidAlgorithmParameterException("Invalid hash id parameter (" + Util.toString(by) + "). Expected " + Util.toString(this.e) + ".");
            }
            this.e = by;
        }
        this.f = iSO9796P2ParameterSpec.getUseExplicitTrailer();
        this.n = iSO9796P2ParameterSpec.getUseAlternativeSignatureFunction();
        this.setSecureRandom(iSO9796P2ParameterSpec.getSecureRandom());
        if (algorithmParameterSpec instanceof RawISO9796P2ParameterSpec) {
            RawISO9796P2ParameterSpec rawISO9796P2ParameterSpec = (RawISO9796P2ParameterSpec)algorithmParameterSpec;
            this.a(rawISO9796P2ParameterSpec.getMr(), rawISO9796P2ParameterSpec.getMsgLen(), rawISO9796P2ParameterSpec.a());
        }
    }

    protected boolean checkHashEngineName(String string) {
        boolean bl = true;
        if (string != null) {
            if (this.hashEngine_ != null) {
                bl = string.equalsIgnoreCase(this.hashEngine_.getAlgorithm());
            }
            if (!bl && this.o != null) {
                bl = string.equalsIgnoreCase(this.o.getAlgorithm());
            }
        }
        return bl;
    }

    void a(byte[] byArray, int n2, MessageDigest messageDigest) throws InvalidAlgorithmParameterException {
        if (messageDigest != null && this.m && !this.checkHashEngineName(messageDigest.getAlgorithm())) {
            throw new InvalidAlgorithmParameterException("Invalid hash engine parameter (" + messageDigest.getAlgorithm() + "). Expected " + this.hashEngine_.getAlgorithm() + ".");
        }
        this.l = n2;
        this.o = messageDigest;
        if (this.i == null) {
            this.b();
        }
        this.k = Math.min(this.i.length, byArray.length);
        System.arraycopy(byArray, 0, this.i, 0, this.k);
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        return this.engineGetParameters();
    }

    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters = null;
        if (this.j != null) {
            try {
                algorithmParameters = AlgorithmParameters.getInstance("ISO9796-2-RM", "IAIK");
                algorithmParameters.init(this.j);
                return algorithmParameters;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return algorithmParameters;
    }

    protected void reset(BigInteger bigInteger) {
        if (this.hashEngine_ != null) {
            this.hashEngine_.reset();
        }
        if (this.o != null) {
            this.o.reset();
        }
        this.l = 0;
        this.k = 0;
        if (bigInteger != null) {
            this.i = null;
            this.g = 0;
            this.p = bigInteger;
            this.h = bigInteger.bitLength();
            this.q = null;
            this.j = null;
        } else if (this.i != null) {
            CryptoUtils.zeroBlock(this.i);
        }
    }

    protected byte[] engineSign() throws SignatureException {
        int n2;
        byte[] byArray;
        if (this.hashEngine_ == null && this.o == null) {
            throw new NullPointerException("MessageDigest engine must not be null!");
        }
        if (this.i == null) {
            this.b();
        }
        if (this.h == 0) {
            throw new IllegalStateException("Length of public parameter not set");
        }
        this.j = null;
        if (this.o != null) {
            byArray = this.o.digest();
            this.hashEngine_.reset();
        } else {
            byArray = this.hashEngine_.digest();
        }
        int n3 = (this.h + 7) / 8;
        byte[] byArray2 = new byte[n3];
        int n4 = n3 - 1;
        if (this.f) {
            byArray2[n4] = -52;
            byArray2[--n4] = this.e;
        } else {
            byArray2[n4] = -68;
        }
        if ((n4 -= byArray.length) < 1) {
            throw new SignatureException("Modulus too short!");
        }
        System.arraycopy(byArray, 0, byArray2, n4, byArray.length);
        int n5 = this.l;
        int n6 = this.l * 8;
        int n7 = (this.g - n6) % 8;
        if (n7 < 0) {
            n7 += 8;
        }
        if ((n2 = this.g - n7) < n6) {
            n5 = n2 / 8;
            byArray2[0] = 107;
        } else {
            byArray2[0] = 75;
        }
        if (n5 > 0) {
            if (n5 > this.i.length) {
                CryptoUtils.zeroBlock(byArray2);
                throw new SignatureException("Partial message to short.");
            }
            if ((n4 -= n5) < 1) {
                CryptoUtils.zeroBlock(byArray2);
                throw new SignatureException("Modulus too short!");
            }
            System.arraycopy(this.i, 0, byArray2, n4, n5);
        }
        for (int i2 = --n4; i2 > 0; --i2) {
            byArray2[i2] = -69;
        }
        int n8 = n4;
        byArray2[n8] = (byte)(byArray2[n8] ^ 1);
        byte[] byArray3 = this.a(byArray2);
        this.reset(null);
        CryptoUtils.zeroBlock(byArray2);
        return byArray3;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        int n2;
        byte by;
        Object object;
        this.j = null;
        if (this.h == 0) {
            throw new IllegalStateException("Length of public parameter not set");
        }
        byte[] byArray2 = this.b(byArray);
        if (byArray2.length * 8 != this.h) {
            CryptoUtils.zeroBlock(byArray2);
            throw new SignatureException("Invalid signature. Message representative not k bits long.");
        }
        boolean bl = true;
        byte by2 = (byte)(byArray2[0] & 0xFFFFFFE0);
        if (by2 == 96) {
            bl = false;
        } else if (by2 != 64) {
            CryptoUtils.zeroBlock(byArray2);
            throw new SignatureException("Invalid signature. Leftmost bits are not 01.");
        }
        if ((byArray2[byArray2.length - 1] & 0xF) != 12) {
            CryptoUtils.zeroBlock(byArray2);
            throw new SignatureException("Invalid signature. Final trailer nibble not 1100.");
        }
        int n3 = 1;
        int n4 = byArray2.length - 1;
        if (byArray2[n4] == -52) {
            if (byArray2[--n4] != this.e) {
                object = this.b(byArray2[n4]);
                if (object == null) {
                    CryptoUtils.zeroBlock(byArray2);
                    throw new SignatureException("Invalid hash id. Expected " + Util.toString(this.e));
                }
                this.hashEngine_ = object;
                this.d = Util.getDigestLength(this.hashEngine_.getAlgorithm());
            }
        } else if (byArray2[n4] != -68) {
            CryptoUtils.zeroBlock(byArray2);
            throw new SignatureException("Invalid trailer byte. Expected 0xBC or 0xCC.");
        }
        if (this.hashEngine_ == null && this.o == null) {
            CryptoUtils.zeroBlock(byArray2);
            throw new NullPointerException("MessageDigest engine must not be null!");
        }
        if (this.d <= 0) {
            object = null;
            object = this.hashEngine_ != null ? this.hashEngine_.getAlgorithm() : this.o.getAlgorithm();
            this.d = Util.getDigestLength((String)object);
        }
        if ((by = (byte)(byArray2[0] & 0xF)) != 10) {
            if (by != 11) {
                CryptoUtils.zeroBlock(byArray2);
                throw new SignatureException("Invalid padding. Must only contain zero bits");
            }
            if (!bl) {
                CryptoUtils.zeroBlock(byArray2);
                throw new SignatureException("Too many padding bits for partial recovery.");
            }
            while (byArray2[n3] == -69 && n3 < n4) {
                ++n3;
            }
            if (n4 <= n3) {
                CryptoUtils.zeroBlock(byArray2);
                throw new SignatureException("Invalid padding.");
            }
            if (byArray2[n3++] != -70) {
                CryptoUtils.zeroBlock(byArray2);
                throw new SignatureException("Invalid padding. Wrong border nibble.");
            }
        }
        if ((n4 -= this.d) < n3) {
            CryptoUtils.zeroBlock(byArray2);
            throw new SignatureException("Invalid padding.");
        }
        int n5 = n4 - n3;
        int n6 = n2 = this.l > 0 ? this.l - n5 : 0;
        if (this.i != null && !CryptoUtils.secureEqualsBlock(byArray2, n3, this.i, 0, n5)) {
            CryptoUtils.zeroBlock(byArray2);
            throw new SignatureException("Invalid message recovery.");
        }
        this.j = new byte[n5];
        System.arraycopy(byArray2, n3, this.j, 0, n5);
        if (bl) {
            if (n2 != 0) {
                CryptoUtils.zeroBlock(byArray2);
                CryptoUtils.zeroBlock(this.j);
                this.j = null;
                throw new SignatureException("Invalid padding. Mn must be empty for total recovery");
            }
            if (this.hashEngine_ == null) {
                CryptoUtils.zeroBlock(byArray2);
                CryptoUtils.zeroBlock(this.j);
                throw new NullPointerException("MessageDigest engine must not be null!");
            }
            this.hashEngine_.reset();
            object = this.hashEngine_.digest(this.j);
        } else {
            if (n2 < 1) {
                CryptoUtils.zeroBlock(byArray2);
                CryptoUtils.zeroBlock(this.j);
                this.j = null;
                throw new SignatureException("Invalid padding. Mn cannot be empty for partial recovery");
            }
            if (this.i == null) {
                CryptoUtils.zeroBlock(byArray2);
                CryptoUtils.zeroBlock(this.j);
                this.j = null;
                throw new NullPointerException("Recovered message part not initialized!");
            }
            object = this.o != null ? this.o.digest() : this.hashEngine_.digest();
        }
        boolean bl2 = CryptoUtils.secureEqualsBlock(byArray2, n4, (byte[])object, 0, this.d);
        CryptoUtils.zeroBlock(byArray2);
        if (!bl2) {
            CryptoUtils.zeroBlock(this.j);
            this.j = null;
        }
        this.reset(null);
        return bl2;
    }

    byte[] a(byte[] byArray) throws SignatureException {
        byte[] byArray2 = this.produceSignature(byArray);
        if (!this.n) {
            BigInteger bigInteger = new BigInteger(1, byArray2);
            bigInteger = bigInteger.min(this.p.subtract(bigInteger));
            byArray2 = ISO9796P2Signature.a(bigInteger.toByteArray(), (this.h + 7) / 8);
        }
        return byArray2;
    }

    byte[] b(byte[] byArray) throws SignatureException {
        byte[] byArray2 = this.openSignature(byArray);
        BigInteger bigInteger = new BigInteger(1, byArray2);
        BigInteger bigInteger2 = bigInteger.mod(b);
        boolean bl = true;
        if (bigInteger2.compareTo(a) != 0) {
            bl = false;
            if (!this.n) {
                if (this.q == null) {
                    this.q = this.p.subtract(a).mod(b);
                }
                if (bigInteger2.compareTo(this.q) == 0) {
                    bigInteger2 = (bigInteger = this.p.subtract(bigInteger)).mod(b);
                    if (bigInteger2.compareTo(a) == 0) {
                        bl = true;
                    }
                    byArray2 = ISO9796P2Signature.a(bigInteger.toByteArray(), (this.h + 7) / 8);
                } else {
                    CryptoUtils.zeroBlock(byArray2);
                    bigInteger = null;
                    bigInteger2 = null;
                    throw new SignatureException("Signature out of range!");
                }
            }
            if (!bl && (byArray2[0] & 0x80) != 0) {
                CryptoUtils.zeroBlock(byArray2);
                bigInteger = null;
                bigInteger2 = null;
                throw new SignatureException("Signature out of range!");
            }
        }
        bigInteger = null;
        bigInteger2 = null;
        return byArray2;
    }

    protected abstract byte[] produceSignature(byte[] var1) throws SignatureException;

    protected abstract byte[] openSignature(byte[] var1) throws SignatureException;

    protected void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom_ = secureRandom;
    }

    protected SecureRandom getSecureRandom() {
        if (this.secureRandom_ == null) {
            SecureRandom secureRandom = this.appRandom == null ? SecRandom.getDefault() : this.appRandom;
            this.setSecureRandom(secureRandom);
        }
        return this.secureRandom_;
    }

    MessageDigest b(byte by) {
        String string;
        MessageDigest messageDigest = null;
        if (!this.m && by == 51 && this.i != null && this.k > 0 && this.o != null && (string = ISO9796P2Signature.a(by)) != null) {
            try {
                messageDigest = MessageDigest.getInstance(string, "IAIK");
            }
            catch (Exception exception) {
                try {
                    this.hashEngine_ = MessageDigest.getInstance(string);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return messageDigest;
    }

    static {
        c.put(new Byte(49), "RIPEMD160");
        c.put(new Byte(50), "RIPEMD128");
        c.put(new Byte(51), "SHA1");
        c.put(new Byte(52), "SHA256");
        c.put(new Byte(54), "SHA384");
        c.put(new Byte(53), "SHA512");
        c.put(new Byte(55), "WHIRLPOOL");
    }
}

