/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs12.AuthenticatedSafe;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS8ShroudedKeyBag;
import iaik.pkcs.pkcs12.SafeBag;
import iaik.pkcs.pkcs7.ContentInfo;
import iaik.pkcs.pkcs7.Data;
import iaik.pkcs.pkcs7.DigestInfo;
import iaik.security.cipher.PBEKeyBMP;
import iaik.security.pbe.PBEGenParameterSpec;
import iaik.security.random.SecRandom;
import iaik.security.spec.PBEKeyAndParameterSpec;
import iaik.utils.CryptoUtils;
import iaik.utils.InternalErrorException;
import iaik.utils.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Vector;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEParameterSpec;

public class PKCS12 {
    public static final int PUBLIC_KEY_INTEGRITY_MODE = 1;
    public static final int PASSWORD_INTEGRITY_MODE = 2;
    protected AuthenticatedSafe[] authenticated_safes;
    protected int mode = 0;
    private int g = 3;
    SEQUENCE a = null;
    ASN1Object b = null;
    byte[] c;
    PKCS8ShroudedKeyBag[] d;
    boolean e;
    private int h = 1024;
    static Class f;

    private PKCS12() {
    }

    public PKCS12(KeyBag keyBag, CertificateBag[] certificateBagArray) throws PKCSException {
        this(keyBag, certificateBagArray, true);
    }

    public PKCS12(KeyBag keyBag, CertificateBag[] certificateBagArray, boolean bl) throws PKCSException {
        this(new KeyBag[]{keyBag}, certificateBagArray, bl);
    }

    public PKCS12(KeyBag[] keyBagArray, CertificateBag[] certificateBagArray, boolean bl) throws PKCSException {
        this();
        this.authenticated_safes = new AuthenticatedSafe[2];
        if (keyBagArray != null && keyBagArray.length > 0) {
            Vector<KeyBag> vector = new Vector<KeyBag>();
            for (int i2 = 0; i2 < keyBagArray.length; ++i2) {
                KeyBag keyBag = keyBagArray[i2];
                if (keyBag == null) continue;
                if (keyBag instanceof PKCS8ShroudedKeyBag) {
                    vector.addElement(keyBag);
                    continue;
                }
                vector.addElement(new PKCS8ShroudedKeyBag(keyBag));
            }
            this.d = new PKCS8ShroudedKeyBag[vector.size()];
            vector.copyInto(this.d);
        }
        if (certificateBagArray != null && certificateBagArray.length > 0) {
            this.authenticated_safes[1] = new AuthenticatedSafe(2, certificateBagArray, this.h);
        }
        this.mode = 2;
        this.e = bl;
    }

    public PKCS12(InputStream inputStream) throws IOException, PKCSParsingException {
        this();
        try {
            this.b = DerCoder.decode(inputStream);
        }
        catch (CodingException codingException) {
            throw new PKCSParsingException(codingException.getMessage());
        }
        this.decode();
    }

    public PKCS12(ASN1Object aSN1Object) throws PKCSParsingException {
        this();
        this.b = aSN1Object;
        this.decode();
    }

    protected void decode() throws PKCSParsingException {
        block9: {
            try {
                if (this.b.getComponentAt(0).isA(ASN.CON_SPEC)) {
                    throw new PKCSParsingException("Key format of Netscape 4.03 and earlier not supportet!");
                }
                this.g = ((BigInteger)this.b.getComponentAt(0).getValue()).intValue();
                ContentInfo contentInfo = new ContentInfo(this.b.getComponentAt(1));
                if (this.b.countComponents() == 3) {
                    this.a = (SEQUENCE)this.b.getComponentAt(2);
                }
                if (contentInfo.getContentType().equals(ObjectID.pkcs7_data)) {
                    this.mode = 2;
                    this.c = ((Data)contentInfo.getContent()).getData();
                    ASN1Object aSN1Object = DerCoder.decode(this.c);
                    this.authenticated_safes = new AuthenticatedSafe[aSN1Object.countComponents()];
                    for (int i2 = 0; i2 < aSN1Object.countComponents(); ++i2) {
                        this.authenticated_safes[i2] = new AuthenticatedSafe(aSN1Object.getComponentAt(i2));
                    }
                    break block9;
                }
                if (contentInfo.getContentType().equals(ObjectID.pkcs7_signedData)) {
                    this.mode = 1;
                    break block9;
                }
                throw new PKCSParsingException("PKCS#12: Unknown mode!");
            }
            catch (PKCSException pKCSException) {
                throw new PKCSParsingException(pKCSException.toString());
            }
            catch (CodingException codingException) {
                throw new PKCSParsingException(codingException.toString());
            }
            catch (ClassCastException classCastException) {
                throw new PKCSParsingException(classCastException.toString());
            }
        }
    }

    public void decrypt(char[] cArray) throws PKCSException {
        try {
            for (int i2 = 0; i2 < this.authenticated_safes.length; ++i2) {
                this.authenticated_safes[i2].decrypt(cArray);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSException(noSuchAlgorithmException.toString());
        }
    }

    public AuthenticatedSafe[] getAuthenticatedSafes() {
        return this.authenticated_safes;
    }

    public KeyBag getKeyBag() {
        for (int i2 = 0; i2 < this.authenticated_safes.length; ++i2) {
            SafeBag[] safeBagArray = this.authenticated_safes[i2].getSafeBags();
            for (int i3 = 0; i3 < safeBagArray.length; ++i3) {
                if (!(safeBagArray[i3] instanceof KeyBag)) continue;
                return (KeyBag)safeBagArray[i3];
            }
        }
        return null;
    }

    public KeyBag[] getKeyBags() {
        Vector<SafeBag> vector = new Vector<SafeBag>(2);
        for (int i2 = 0; i2 < this.authenticated_safes.length; ++i2) {
            SafeBag[] safeBagArray = this.authenticated_safes[i2].getSafeBags();
            for (int i3 = 0; i3 < safeBagArray.length; ++i3) {
                if (!(safeBagArray[i3] instanceof KeyBag)) continue;
                vector.addElement(safeBagArray[i3]);
            }
        }
        Object[] objectArray = new KeyBag[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public CertificateBag[] getCertificateBags() {
        Vector<SafeBag> vector = new Vector<SafeBag>();
        for (int i2 = 0; i2 < this.authenticated_safes.length; ++i2) {
            SafeBag[] safeBagArray = this.authenticated_safes[i2].getSafeBags();
            for (int i3 = 0; i3 < safeBagArray.length; ++i3) {
                if (!(safeBagArray[i3] instanceof CertificateBag)) continue;
                vector.addElement(safeBagArray[i3]);
            }
        }
        Object[] objectArray = new CertificateBag[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean verify(char[] cArray) throws PKCSException {
        try {
            DigestInfo digestInfo = new DigestInfo(this.a.getComponentAt(0));
            byte[] byArray = (byte[])this.a.getComponentAt(1).getValue();
            int n2 = 1;
            if (this.a.countComponents() > 2) {
                n2 = ((BigInteger)this.a.getComponentAt(2).getValue()).intValue();
            }
            PBEKeyAndParameterSpec pBEKeyAndParameterSpec = new PBEKeyAndParameterSpec(PBEKeyBMP.getEncoded(cArray), byArray, n2, 20);
            KeyGenerator keyGenerator = KeyGenerator.getInstance("PKCS#12-MAC");
            keyGenerator.init(pBEKeyAndParameterSpec);
            SecretKey secretKey = keyGenerator.generateKey();
            Mac mac = Mac.getInstance("HMAC/SHA");
            mac.init(secretKey);
            byte[] byArray2 = mac.doFinal(this.c);
            return CryptoUtils.secureEqualsBlock(byArray2, digestInfo.getDigest());
        }
        catch (Exception exception) {
            throw new PKCSException(this, exception.getMessage(), exception){
                private final Exception a;
                private final PKCS12 b;
                {
                    this.b = pKCS12;
                    this.a = exception;
                }

                public Throwable getCause() {
                    return this.a;
                }
            };
        }
    }

    public void encrypt(char[] cArray) throws PKCSException {
        this.encrypt(cArray, null, null);
    }

    public void encrypt(char[] cArray, AlgorithmID algorithmID, AlgorithmID algorithmID2) throws PKCSException {
        Object object;
        AlgorithmID algorithmID3 = null;
        AlgorithmID algorithmID4 = null;
        algorithmID3 = algorithmID == null ? (AlgorithmID)AlgorithmID.pbeWithSHAAnd40BitRC2_CBC.clone() : algorithmID;
        algorithmID4 = algorithmID2 == null ? (AlgorithmID)AlgorithmID.pbeWithSHAAnd3_KeyTripleDES_CBC.clone() : algorithmID2;
        try {
            int n2;
            int n3 = this.e ? 2000 : 1;
            PBEGenParameterSpec pBEGenParameterSpec = new PBEGenParameterSpec(8, n3);
            object = SecRandom.getDefault();
            AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("PBE");
            algorithmParameterGenerator.init(pBEGenParameterSpec, (SecureRandom)object);
            AlgorithmParameters algorithmParameters = algorithmParameterGenerator.generateParameters();
            algorithmID3.setAlgorithmParameters(algorithmParameters);
            if (this.d != null && this.d.length > 0) {
                for (n2 = 0; n2 < this.d.length; ++n2) {
                    this.d[n2].encrypt(cArray, algorithmID4, (SecureRandom)object, n3);
                }
                this.authenticated_safes[0] = new AuthenticatedSafe(1, this.d, this.h);
            }
            for (n2 = 0; n2 < this.authenticated_safes.length; ++n2) {
                if (this.authenticated_safes[n2] == null) continue;
                this.authenticated_safes[n2].setBlockSize(this.h);
                this.authenticated_safes[n2].encrypt(cArray, algorithmID3);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalErrorException(noSuchAlgorithmException.toString());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InternalErrorException(invalidAlgorithmParameterException);
        }
        if (this.mode == 2) {
            try {
                SEQUENCE sEQUENCE = new SEQUENCE();
                for (int i2 = 0; i2 < this.authenticated_safes.length; ++i2) {
                    if (this.authenticated_safes[i2] == null) continue;
                    ((ASN1Object)sEQUENCE).addComponent(this.authenticated_safes[i2].toASN1Object());
                }
                if (((ASN1Object)sEQUENCE).countComponents() == 0) {
                    throw new PKCSException("No key/cert bags set!");
                }
                sEQUENCE.setIndefiniteLength(this.h > 0);
                this.c = DerCoder.encode(sEQUENCE);
                Data data = new Data(this.c);
                data.setBlockSize(this.h);
                object = new ContentInfo(data);
                this.a(cArray);
                this.b = new SEQUENCE();
                this.b.addComponent(new INTEGER(this.g));
                this.b.addComponent(((ContentInfo)object).toASN1Object());
                if (this.a != null) {
                    this.b.addComponent(this.a);
                }
                this.b.setIndefiniteLength(this.h > 0);
            }
            catch (CodingException codingException) {
                throw new RuntimeException(codingException.toString());
            }
        }
    }

    private void a(char[] cArray) throws PKCSException {
        try {
            int n2 = this.e ? 2000 : 1;
            PBEGenParameterSpec pBEGenParameterSpec = new PBEGenParameterSpec(8, n2);
            AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("PBE");
            algorithmParameterGenerator.init(pBEGenParameterSpec);
            AlgorithmParameters algorithmParameters = algorithmParameterGenerator.generateParameters();
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameters.getParameterSpec(f == null ? (f = PKCS12.class$("javax.crypto.spec.PBEParameterSpec")) : f);
            PBEKeyAndParameterSpec pBEKeyAndParameterSpec = new PBEKeyAndParameterSpec(PBEKeyBMP.getEncoded(cArray), pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount(), 20);
            KeyGenerator keyGenerator = KeyGenerator.getInstance("PKCS#12-MAC");
            keyGenerator.init(pBEKeyAndParameterSpec);
            SecretKey secretKey = keyGenerator.generateKey();
            Mac mac = Mac.getInstance("HMAC/SHA");
            mac.init(secretKey);
            byte[] byArray = mac.doFinal(this.c);
            DigestInfo digestInfo = new DigestInfo(AlgorithmID.sha, byArray);
            this.a = new SEQUENCE();
            this.a.addComponent(digestInfo.toASN1Object());
            this.a.addComponent(new OCTET_STRING(pBEParameterSpec.getSalt()));
            if (pBEParameterSpec.getIterationCount() != 1) {
                this.a.addComponent(new INTEGER(pBEParameterSpec.getIterationCount()));
            }
        }
        catch (Exception exception) {
            throw new PKCSException(this, exception.getMessage(), exception){
                private final Exception a;
                private final PKCS12 b;
                {
                    this.b = pKCS12;
                    this.a = exception;
                }

                public Throwable getCause() {
                    return this.a;
                }
            };
        }
    }

    public ASN1Object toASN1Object() throws PKCSException {
        return this.b;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        DerCoder.encodeTo(this.b, outputStream);
    }

    public void setBlockSize(int n2) {
        this.h = n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PKCS#12 object:\n");
        stringBuffer.append("Version: " + this.g + "\n");
        if (this.authenticated_safes == null) {
            stringBuffer.append("No content.\n");
        } else {
            for (int i2 = 0; i2 < this.authenticated_safes.length; ++i2) {
                stringBuffer.append("AuthenticatedSafe: " + i2 + "\n");
                stringBuffer.append(this.authenticated_safes[i2].toString());
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Util.toString(null, -1, 1);
    }
}

