/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.security.cipher.SecretKey;
import iaik.security.cipher.VarLengthKeyGenerator;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import javax.crypto.spec.DESKeySpec;

public class DESKeyGenerator
extends VarLengthKeyGenerator {
    private static final byte[] a = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};

    public DESKeyGenerator() {
        super("DES", 64);
    }

    protected void engineInit(int n2, SecureRandom secureRandom) {
        if (n2 == -1) {
            n2 = 64;
        } else if (n2 == 56) {
            n2 = 64;
        }
        if (n2 != 64) {
            throw new InvalidParameterException("Invalid DES key length (" + n2 + "). Only 56 or 64 allowed!");
        }
        super.engineInit(n2, secureRandom);
    }

    protected javax.crypto.SecretKey engineGenerateKey() {
        try {
            byte[] byArray;
            do {
                byArray = super.engineGenerateKey().getEncoded();
                DESKeyGenerator.adjustParity(byArray, 0);
            } while (DESKeySpec.isWeak(byArray, 0));
            return new SecretKey(byArray, "DES");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException.toString());
        }
    }

    public static void adjustParity(byte[] byArray, int n2) {
        for (int i2 = 0; i2 < 8; ++i2) {
            int n3 = 0;
            for (int i3 = 1; i3 < a.length; ++i3) {
                if ((byArray[i2 + n2] & a[i3]) != a[i3]) continue;
                ++n3;
            }
            if ((n3 & 1) > 0) {
                int n4 = i2 + n2;
                byArray[n4] = (byte)(byArray[n4] & 0xFFFFFFFE);
                continue;
            }
            int n5 = i2 + n2;
            byArray[n5] = (byte)(byArray[n5] | 1);
        }
    }

    public static boolean checkParity(byte[] byArray, int n2, boolean bl) {
        for (int i2 = 0; i2 < 8; ++i2) {
            int n3 = 0;
            for (int i3 = 0; i3 < a.length; ++i3) {
                if ((byArray[i2 + n2] & a[i3]) != a[i3]) continue;
                ++n3;
            }
            if (!((n3 & 1) > 0 ? !bl : bl)) continue;
            return false;
        }
        return true;
    }
}

