/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dsa;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.security.random.SecRandom;
import iaik.utils.NumberTheory;
import iaik.utils.Util;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;

public final class RawDSA
extends SignatureSpi {
    private BigInteger a;
    private BigInteger b;
    private BigInteger c;
    private BigInteger d;
    private BigInteger e;
    private SecureRandom f;
    private byte[] g;
    protected ByteArrayOutputStream dataBuffer_ = new ByteArrayOutputStream(32);

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("Key must be an instance of java.security.interfaces.DSAPublicKey!");
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        this.b = dSAPublicKey.getY();
        DSAParams dSAParams = dSAPublicKey.getParams();
        if (dSAParams != null) {
            this.a(dSAParams);
        }
        this.dataBuffer_.reset();
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("Key must be an instance of java.security.interfaces.DSAPrivateKey!");
        }
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
        this.a = dSAPrivateKey.getX();
        this.a(dSAPrivateKey.getParams());
        this.dataBuffer_.reset();
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.f = secureRandom;
        this.engineInitSign(privateKey);
    }

    private void a(DSAParams dSAParams) {
        this.c = dSAParams.getP();
        this.d = dSAParams.getQ();
        this.e = dSAParams.getG();
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.dataBuffer_.write(by);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.dataBuffer_.write(byArray, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] byArray = this.a(this.dsaSignRS());
            return byArray;
        }
        finally {
            this.dataBuffer_.reset();
        }
    }

    public BigInteger[] dsaSignRS() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        while ((bigInteger3 = this.a(bigInteger2 = this.a())).equals(NumberTheory.ZERO) || (bigInteger = this.b(bigInteger2, bigInteger3)).equals(NumberTheory.ZERO)) {
        }
        BigInteger[] bigIntegerArray = new BigInteger[]{bigInteger3, bigInteger};
        return bigIntegerArray;
    }

    byte[] a(BigInteger[] bigIntegerArray) throws SignatureException {
        return this.a(bigIntegerArray[0], bigIntegerArray[1]);
    }

    byte[] a(BigInteger bigInteger, BigInteger bigInteger2) throws SignatureException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new INTEGER(bigInteger));
        sEQUENCE.addComponent(new INTEGER(bigInteger2));
        try {
            byte[] byArray = new ASN1(sEQUENCE).toByteArray();
            return byArray;
        }
        catch (CodingException codingException) {
            throw new SignatureException();
        }
    }

    private BigInteger a() {
        BigInteger bigInteger;
        if (this.g == null) {
            if (this.f == null) {
                this.f = SecRandom.getDefault();
            }
            int n2 = this.d.bitLength() + 64;
            bigInteger = new BigInteger(n2, this.f);
        } else {
            bigInteger = new BigInteger(1, this.g);
            bigInteger = bigInteger.subtract(NumberTheory.ONE);
        }
        BigInteger bigInteger2 = bigInteger.mod(this.d.subtract(NumberTheory.ONE)).add(NumberTheory.ONE);
        return bigInteger2;
    }

    private BigInteger a(BigInteger bigInteger) {
        BigInteger bigInteger2 = this.e.modPow(bigInteger, this.c);
        BigInteger bigInteger3 = bigInteger2.mod(this.d);
        return bigInteger3;
    }

    private BigInteger b(BigInteger bigInteger, BigInteger bigInteger2) {
        byte[] byArray = this.dataBuffer_.toByteArray();
        int n2 = byArray.length * 8;
        int n3 = this.d.bitLength();
        BigInteger bigInteger3 = new BigInteger(1, byArray);
        BigInteger bigInteger4 = n3 >= n2 ? bigInteger3 : bigInteger3.shiftRight(n2 - n3);
        BigInteger bigInteger5 = bigInteger.modInverse(this.d);
        BigInteger bigInteger6 = this.a.multiply(bigInteger2);
        BigInteger bigInteger7 = bigInteger4.add(bigInteger6);
        BigInteger bigInteger8 = bigInteger5.multiply(bigInteger7);
        BigInteger bigInteger9 = bigInteger8.mod(this.d);
        return bigInteger9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        try {
            boolean bl = this.dsaVerifyRS(this.a(byArray));
            return bl;
        }
        finally {
            this.dataBuffer_.reset();
        }
    }

    BigInteger[] a(byte[] byArray) throws SignatureException {
        try {
            ASN1 aSN1 = new ASN1(byArray);
            if (aSN1.toASN1Object().isA(ASN.SEQUENCE) && aSN1.countComponents() == 2) {
                ASN1Object aSN1Object = aSN1.getComponentAt(0);
                ASN1Object aSN1Object2 = aSN1.getComponentAt(1);
                BigInteger bigInteger = (BigInteger)aSN1Object.getValue();
                BigInteger bigInteger2 = (BigInteger)aSN1Object2.getValue();
                BigInteger[] bigIntegerArray = new BigInteger[]{bigInteger, bigInteger2};
                return bigIntegerArray;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new SignatureException();
    }

    public boolean dsaVerifyRS(BigInteger[] bigIntegerArray) {
        return this.dsaVerifyRS(bigIntegerArray[0], bigIntegerArray[1]);
    }

    public boolean dsaVerifyRS(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger.signum() != 1 || bigInteger2.signum() != 1) {
            return false;
        }
        if (bigInteger.compareTo(this.d) >= 0 || bigInteger2.compareTo(this.d) >= 0) {
            return false;
        }
        BigInteger bigInteger3 = this.c(bigInteger, bigInteger2);
        BigInteger bigInteger4 = this.a(bigInteger, bigInteger2, bigInteger3);
        BigInteger bigInteger5 = this.b(bigInteger, bigInteger2, bigInteger3);
        BigInteger bigInteger6 = this.d(bigInteger4, bigInteger5);
        return bigInteger.equals(bigInteger6);
    }

    private BigInteger c(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger2.modInverse(this.d);
        return bigInteger3;
    }

    private BigInteger a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        byte[] byArray = this.dataBuffer_.toByteArray();
        int n2 = byArray.length * 8;
        int n3 = this.d.bitLength();
        BigInteger bigInteger4 = new BigInteger(1, byArray);
        BigInteger bigInteger5 = n3 >= n2 ? bigInteger4 : bigInteger4.shiftRight(n2 - n3);
        BigInteger bigInteger6 = bigInteger5.multiply(bigInteger3);
        BigInteger bigInteger7 = bigInteger6.mod(this.d);
        return bigInteger7;
    }

    private BigInteger b(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger bigInteger4 = bigInteger.multiply(bigInteger3);
        BigInteger bigInteger5 = bigInteger4.mod(this.d);
        return bigInteger5;
    }

    private BigInteger d(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = this.e.modPow(bigInteger, this.c);
        BigInteger bigInteger4 = this.b.modPow(bigInteger2, this.c);
        BigInteger bigInteger5 = bigInteger3.multiply(bigInteger4);
        BigInteger bigInteger6 = bigInteger5.mod(this.c);
        BigInteger bigInteger7 = bigInteger6.mod(this.d);
        return bigInteger7;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        if (string != null && string.equals("KSEED")) {
            if (object == null) {
                this.g = null;
                return;
            } else if (object instanceof byte[]) {
                this.g = (byte[])object;
                return;
            } else {
                if (!(object instanceof BigInteger)) throw new InvalidParameterException("KSEED must be a either a byte array or a BigInteger");
                this.g = ((BigInteger)object).toByteArray();
            }
            return;
        }
        if (object instanceof SecureRandom) {
            this.f = (SecureRandom)object;
            return;
        }
        if (!(object instanceof DSAParameterSpec)) throw new InvalidParameterException("Invalid parameter; only KSEED, SecureRandom or DSAParameterSpec are allowed!");
        if (string != null && !string.equals("DSAParameterSpec")) {
            throw new InvalidParameterException("Invalid param name for DSAParameterSpec: " + string);
        }
        try {
            this.engineSetParameter((DSAParameterSpec)object);
            return;
        }
        catch (Exception exception) {
            throw new InvalidParameterException(exception.getMessage());
        }
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Not a DSAParameterSpec");
        }
        this.a((DSAParameterSpec)algorithmParameterSpec);
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        if (string != null && string.equals("KSEED")) {
            return this.g;
        }
        return this.engineGetParameters();
    }

    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters = null;
        if (this.c != null && this.d != null && this.e != null) {
            try {
                DSAParameterSpec dSAParameterSpec = new DSAParameterSpec(this.c, this.d, this.e);
                algorithmParameters = AlgorithmParameters.getInstance("DSA", "IAIK");
                algorithmParameters.init(dSAParameterSpec);
                return algorithmParameters;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return algorithmParameters;
    }

    void a(SecureRandom secureRandom) {
        this.f = secureRandom;
    }

    static {
        Util.toString(null, -1, 1);
    }
}

