/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import java.io.IOException;

public class URLDecoder {
    public static String decode(String string) throws IOException {
        String string2;
        if (string == null) {
            throw new NullPointerException("Parameter \"url\" must not be null.");
        }
        try {
            string2 = URLDecoder.decodeUTF8(string);
        }
        catch (IOException iOException) {
            string2 = URLDecoder.decodeISO8859_1(string);
        }
        return string2;
    }

    public static String decodeUTF8(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("Parameter \"url\" must not be null.");
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != '%') {
                stringBuffer.append(c2);
                continue;
            }
            try {
                int n2;
                int[] nArray = new int[3];
                nArray[0] = Integer.parseInt(string.substring(i2 + 1, i2 + 3), 16);
                if ((nArray[0] & 0xE0) == 224) {
                    nArray[1] = Integer.parseInt(string.substring(i2 + 4, i2 + 6), 16);
                    nArray[2] = Integer.parseInt(string.substring(i2 + 7, i2 + 9), 16);
                    n2 = ((nArray[0] & 0xF) << 12) + ((nArray[1] & 0x3F) << 6) + (nArray[2] & 0x3F);
                    stringBuffer.append((char)n2);
                    i2 += 8;
                    continue;
                }
                if ((nArray[0] & 0xC0) == 192) {
                    nArray[1] = Integer.parseInt(string.substring(i2 + 4, i2 + 6), 16);
                    n2 = ((nArray[0] & 0x1F) << 6) + (nArray[1] & 0x3F);
                    stringBuffer.append((char)n2);
                    i2 += 5;
                    continue;
                }
                if ((nArray[0] & 0x80) == 0) {
                    stringBuffer.append((char)nArray[0]);
                    i2 += 2;
                    continue;
                }
                throw new IOException("Invlaid URI.");
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Invalid UTF-8 encoding.");
            }
        }
        return stringBuffer.toString();
    }

    public static String decodeISO8859_1(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != '%') {
                stringBuffer.append(c2);
                continue;
            }
            try {
                int[] nArray = new int[3];
                nArray[0] = Integer.parseInt(string.substring(i2 + 1, i2 + 3), 16);
                stringBuffer.append((char)nArray[0]);
                i2 += 2;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Error while ISO8859-1 decoding url. Invalid escape sequence (%" + string.substring(i2 + 1, i2 + 3) + ") in URL.");
            }
        }
        return stringBuffer.toString();
    }
}

