/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.DistributionPoint;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.extensions.FreshestCRL;
import java.util.Enumeration;
import java.util.Vector;

public abstract class CRLDistPointsSyntax
extends V3Extension {
    private Vector a = new Vector();

    public CRLDistPointsSyntax() {
    }

    public CRLDistPointsSyntax(DistributionPoint distributionPoint) {
        this();
        this.addDistributionPoint(distributionPoint);
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        DistributionPoint distributionPoint = null;
        try {
            for (int i2 = 0; i2 < aSN1Object.countComponents(); ++i2) {
                distributionPoint = new DistributionPoint(aSN1Object.getComponentAt(i2));
                if (this instanceof FreshestCRL) {
                    distributionPoint.setLdapAttributeDescription("deltaRevocationList;binary");
                }
                this.a.addElement(distributionPoint);
            }
        }
        catch (Exception exception) {
            throw new X509ExtensionException(exception.getMessage());
        }
    }

    public ASN1Object toASN1Object() throws X509ExtensionException {
        try {
            SEQUENCE sEQUENCE = new SEQUENCE();
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                DistributionPoint distributionPoint = (DistributionPoint)this.a.elementAt(i2);
                sEQUENCE.addComponent(distributionPoint.toASN1Object());
            }
            return sEQUENCE;
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException(codingException.toString());
        }
    }

    public void addDistributionPoint(DistributionPoint distributionPoint) {
        if (this instanceof FreshestCRL) {
            distributionPoint.setLdapAttributeDescription("deltaRevocationList;binary");
        }
        this.a.addElement(distributionPoint);
    }

    public void removeAllDistributionPoints() {
        this.a.removeAllElements();
    }

    public Enumeration getDistributionPoints() {
        return this.a.elements();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            stringBuffer.append(this.a.elementAt(i2).toString() + "\n");
            if (stringBuffer.length() < 1) continue;
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }
}

