/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp.extensions;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.utils.CryptoUtils;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.extensions.smime.SMIMECapability;

public class PreferredSignatureAlgorithms
extends V3Extension {
    public static final ObjectID oid = ObjectID.ocspExt_PreferredSignatureAlgorithms;
    private PreferredSignatureAlgorithm[] a;

    public PreferredSignatureAlgorithms() {
    }

    public PreferredSignatureAlgorithms(PreferredSignatureAlgorithm[] preferredSignatureAlgorithmArray) {
        if (preferredSignatureAlgorithmArray == null) {
            throw new IllegalArgumentException("algorithms must not be null!");
        }
        if (preferredSignatureAlgorithmArray.length == 0) {
            throw new IllegalArgumentException("algorithms must not be empty!");
        }
        this.a = preferredSignatureAlgorithmArray;
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public PreferredSignatureAlgorithm[] getAlgorithms() {
        return this.a;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        if (!aSN1Object.getAsnType().equals(ASN.SEQUENCE)) {
            throw new X509ExtensionException("Invalid ASN.1 representation. Expected ASN.1 SEQUENCE!");
        }
        try {
            int n2 = aSN1Object.countComponents();
            this.a = new PreferredSignatureAlgorithm[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.a[i2] = new PreferredSignatureAlgorithm(aSN1Object.getComponentAt(i2));
            }
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException("Error parsing extension: " + codingException.toString());
        }
    }

    public ASN1Object toASN1Object() throws X509ExtensionException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        try {
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                sEQUENCE.addComponent(this.a[i2].toASN1Object());
            }
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException(codingException.toString());
        }
        return sEQUENCE;
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PreferredSignatureAlgorithms)) {
            return false;
        }
        PreferredSignatureAlgorithms preferredSignatureAlgorithms = (PreferredSignatureAlgorithms)object;
        try {
            return CryptoUtils.equalsBlock(DerCoder.encode(this.toASN1Object()), DerCoder.encode(preferredSignatureAlgorithms.toASN1Object()));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append("Preferred signature algorithms:\n");
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                stringBuffer.append("{ \n" + this.a[i2] + "\n}");
            }
        }
        return stringBuffer.toString();
    }

    public static final class PreferredSignatureAlgorithm {
        private AlgorithmID a;
        private SMIMECapability b;

        public PreferredSignatureAlgorithm(AlgorithmID algorithmID) {
            if (algorithmID == null) {
                throw new IllegalArgumentException("sigIdentifier must not be null!");
            }
            this.a = algorithmID;
        }

        public PreferredSignatureAlgorithm(ASN1Object aSN1Object) throws CodingException {
            this.decode(aSN1Object);
        }

        public void setPubKeyAlgIdentifier(SMIMECapability sMIMECapability) {
            if (sMIMECapability == null) {
                throw new IllegalArgumentException("pubKeyAlgIdentifier must not be null!");
            }
            this.b = sMIMECapability;
        }

        public SMIMECapability getPubKeyAlgIdentifier() {
            return this.b;
        }

        public AlgorithmID getSigIdentifier() {
            return this.a;
        }

        public void decode(ASN1Object aSN1Object) throws CodingException {
            if (!aSN1Object.isA(ASN.SEQUENCE)) {
                throw new CodingException("PrefferedSignatureAlgorithm must be ASN.1 SEQUENCE!");
            }
            int n2 = aSN1Object.countComponents();
            if (n2 < 1 || n2 > 2) {
                throw new CodingException("Invalid number of components (" + n2 + ")! Only 1 or 2 allowed.");
            }
            this.a = new AlgorithmID(aSN1Object.getComponentAt(0));
            if (n2 == 2) {
                this.b = new SMIMECapability(aSN1Object.getComponentAt(1));
            }
        }

        public ASN1Object toASN1Object() throws CodingException {
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(this.a.toASN1Object());
            if (this.b != null) {
                sEQUENCE.addComponent(this.b.toASN1Object());
            }
            return sEQUENCE;
        }

        public int hashCode() {
            return this.a.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof PreferredSignatureAlgorithm)) {
                return false;
            }
            PreferredSignatureAlgorithm preferredSignatureAlgorithm = (PreferredSignatureAlgorithm)object;
            try {
                return CryptoUtils.equalsBlock(DerCoder.encode(this.toASN1Object()), DerCoder.encode(preferredSignatureAlgorithm.toASN1Object()));
            }
            catch (Exception exception) {
                return false;
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("sigIdentifier: " + this.a);
            if (this.b != null) {
                stringBuffer.append("pubKeyIdentifier: " + this.b);
            }
            return stringBuffer.toString();
        }
    }
}

