/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.cipher;

import iaik.xml.crypto.alg.cipher.ProxyCipher;
import iaik.xml.crypto.alg.cipher.a;
import iaik.xml.crypto.alg.cipher.b;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public abstract class BlockCipherProxyCipher
extends ProxyCipher {
    protected int ivLength_;
    protected byte[] iv_;
    protected int ivPos_;
    protected int opmode_;
    protected Key key_;
    protected SecureRandom random_;
    static Class a;

    protected void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.opmode_ = n2;
        this.key_ = key;
        this.random_ = secureRandom;
        if (algorithmParameters != null) {
            IvParameterSpec ivParameterSpec;
            try {
                ivParameterSpec = (IvParameterSpec)algorithmParameters.getParameterSpec(a == null ? (a = BlockCipherProxyCipher.a("javax.crypto.spec.IvParameterSpec")) : a);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("AlgorithmParameters " + algorithmParameters.getClass().getName() + " not supported.");
            }
            this.iv_ = ivParameterSpec.getIV();
            this.ivLength_ = this.iv_.length;
            this.ivPos_ = this.iv_.length;
            super.engineInit(n2, key, algorithmParameters, secureRandom);
        } else {
            this.engineInit(n2, key, secureRandom);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.opmode_ = n2;
        this.key_ = key;
        this.random_ = secureRandom;
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof IvParameterSpec)) throw new InvalidAlgorithmParameterException("AlgorithmParameter " + (a == null ? (a = BlockCipherProxyCipher.a("javax.crypto.spec.IvParameterSpec")) : a).getName() + " not required.");
            this.iv_ = ((IvParameterSpec)algorithmParameterSpec).getIV();
            this.ivLength_ = this.iv_.length;
            this.ivPos_ = this.iv_.length;
            super.engineInit(n2, key, algorithmParameterSpec, secureRandom);
            return;
        } else {
            this.engineInit(n2, key, secureRandom);
        }
    }

    protected void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.opmode_ = n2;
        this.key_ = key;
        this.random_ = secureRandom;
        if (this.opmode_ == 2 || this.opmode_ == 4) {
            if (this.cipher_ == null) {
                super.getInstance(n2);
            }
            this.iv_ = new byte[this.cipher_.getBlockSize()];
            IvParameterSpec ivParameterSpec = new IvParameterSpec(this.iv_);
            try {
                super.engineInit(n2, key, ivParameterSpec, secureRandom);
                this.ivLength_ = ivParameterSpec.getIV().length;
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                super.engineInit(n2, key, secureRandom);
                this.ivLength_ = 0;
                this.ivPos_ = 0;
            }
        } else {
            super.engineInit(n2, key, secureRandom);
            this.iv_ = this.cipher_.getIV();
            this.ivLength_ = this.iv_ != null ? this.iv_.length : 0;
            this.ivPos_ = 0;
        }
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        if (this.opmode_ == 2 || this.opmode_ == 4) {
            if (this.ivPos_ < this.ivLength_) {
                int n5 = this.readIV(byArray, n2, n3);
                if (n5 < n3) {
                    return super.engineUpdate(byArray, n2 + n5, n3 - n5, byArray2, n4);
                }
                return 0;
            }
            return super.engineUpdate(byArray, n2, n3, byArray2, n4);
        }
        if (this.ivPos_ < this.ivLength_) {
            int n6 = this.writeIV(byArray2, n4);
            return n6 + super.engineUpdate(byArray, n2, n3, byArray2, n4 + n6);
        }
        return super.engineUpdate(byArray, n2, n3, byArray2, n4);
    }

    protected byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        if (this.opmode_ == 2 || this.opmode_ == 4) {
            if (this.ivPos_ < this.ivLength_) {
                int n4 = this.readIV(byArray, n2, n3);
                if (n4 < n3) {
                    return super.engineUpdate(byArray, n2 + n4, n3 - n4);
                }
                return null;
            }
            return super.engineUpdate(byArray, n2, n3);
        }
        if (this.ivPos_ < this.ivLength_) {
            byte[] byArray2 = this.writeIV();
            byte[] byArray3 = super.engineUpdate(byArray, n2, n3);
            return this.concatenate(byArray2, byArray3);
        }
        return super.engineUpdate(byArray, n2, n3);
    }

    protected int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (this.opmode_ == 2 || this.opmode_ == 4) {
            if (this.ivPos_ < this.ivLength_) {
                int n5 = this.readIV(byArray, n2, n3);
                if (n5 < n3) {
                    return super.engineDoFinal(byArray, n2 + n5, n3 - n5, byArray2, n4);
                }
                throw new IllegalBlockSizeException();
            }
            return super.engineDoFinal(byArray, n2, n3, byArray2, n4);
        }
        if (this.ivPos_ < this.ivLength_) {
            int n6 = this.writeIV(byArray2, n4);
            return n6 + super.engineDoFinal(byArray, n2, n3, byArray2, n4 + n6);
        }
        return super.engineDoFinal(byArray, n2, n3, byArray2, n4);
    }

    protected byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        if (this.opmode_ == 2 || this.opmode_ == 4) {
            if (this.ivPos_ < this.ivLength_) {
                int n4 = this.readIV(byArray, n2, n3);
                if (n4 < n3) {
                    return super.engineDoFinal(byArray, n2 + n4, n3 - n4);
                }
                throw new IllegalBlockSizeException();
            }
            return super.engineDoFinal(byArray, n2, n3);
        }
        if (this.ivPos_ < this.ivLength_) {
            byte[] byArray2 = this.writeIV();
            byte[] byArray3 = super.engineDoFinal(byArray, n2, n3);
            return this.concatenate(byArray2, byArray3);
        }
        return super.engineDoFinal(byArray, n2, n3);
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.cipher_.wrap(key);
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n2) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.cipher_.unwrap(byArray, string, n2);
    }

    protected byte[] concatenate(byte[] byArray, byte[] byArray2) {
        int n2;
        int n3 = byArray != null ? byArray.length : 0;
        int n4 = n2 = byArray2 != null ? byArray2.length : 0;
        if (n3 + n2 > 0) {
            byte[] byArray3 = new byte[n3 + n2];
            if (n3 > 0) {
                System.arraycopy(byArray, 0, byArray3, 0, n3);
            }
            if (n2 > 0) {
                System.arraycopy(byArray2, 0, byArray3, n3, n2);
            }
            return byArray3;
        }
        return null;
    }

    protected int readIV(byte[] byArray, int n2, int n3) {
        if (this.ivPos_ < this.ivLength_) {
            int n4 = Math.min(this.ivLength_ - this.ivPos_, n3);
            if (n4 > 0 && byArray != null) {
                System.arraycopy(byArray, n2, this.iv_, this.ivPos_, n4);
            }
            this.ivPos_ += n4;
            if (this.ivPos_ >= this.ivLength_) {
                IvParameterSpec ivParameterSpec = new IvParameterSpec(this.iv_);
                try {
                    this.cipher_.init(this.opmode_, this.key_, ivParameterSpec, this.random_);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new a(this, invalidKeyException.getMessage(), invalidKeyException);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new b(this, invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
                }
            }
            return n4;
        }
        return 0;
    }

    protected byte[] writeIV() {
        if (this.ivPos_ < this.ivLength_) {
            int n2 = this.ivLength_ - this.ivPos_;
            byte[] byArray = new byte[n2];
            System.arraycopy(this.iv_, this.ivPos_, byArray, 0, n2);
            this.ivPos_ += n2;
            return byArray;
        }
        return null;
    }

    protected int writeIV(byte[] byArray, int n2) throws ShortBufferException {
        if (this.ivPos_ < this.ivLength_) {
            int n3 = this.ivLength_ - this.ivPos_;
            if (n2 + n3 > byArray.length) {
                throw new ShortBufferException();
            }
            System.arraycopy(this.iv_, this.ivPos_, byArray, n2, n3);
            this.ivPos_ += n3;
            return n3;
        }
        return 0;
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

