/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyagreements;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.AESSecretKey;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.BlowfishSecretKey;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.CAST128SecretKey;
import iaik.pkcs.pkcs11.objects.CAST3SecretKey;
import iaik.pkcs.pkcs11.objects.CASTSecretKey;
import iaik.pkcs.pkcs11.objects.DES3SecretKey;
import iaik.pkcs.pkcs11.objects.DESSecretKey;
import iaik.pkcs.pkcs11.objects.GenericSecretKey;
import iaik.pkcs.pkcs11.objects.IDEASecretKey;
import iaik.pkcs.pkcs11.objects.RC2SecretKey;
import iaik.pkcs.pkcs11.objects.RC4SecretKey;
import iaik.pkcs.pkcs11.objects.RC5SecretKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.objects.TwofishSecretKey;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keyagreements.PKCS11KeyAgreementSpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.ShortBufferException;

public abstract class PKCS11KeyAgreement
extends KeyAgreementSpi
implements PKCS11EngineClass {
    protected TokenManager e;
    protected Session f;
    protected PKCS11KeyAgreementSpec g;
    protected boolean h;
    protected boolean i;
    protected boolean j;
    protected IAIKPKCS11Key k;
    protected iaik.pkcs.pkcs11.objects.Key l;
    protected IAIKPKCS11Key m;
    protected boolean n;
    protected KeyAgreement o;
    protected Mechanism[] p;
    protected MechanismInfo[][] q;

    protected Mechanism[] a() {
        if (this.p == null) {
            Mechanism mechanism = (Mechanism)this.c().clone();
            mechanism.setParameters(null);
            this.p = new Mechanism[]{mechanism};
        }
        return this.p;
    }

    protected MechanismInfo[][] d() {
        if (this.q == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setDerive(true);
            this.q = new MechanismInfo[][]{{mechanismInfo}};
        }
        return this.q;
    }

    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            Mechanism[] mechanismArray = this.a();
            MechanismInfo[][] mechanismInfoArray = this.d();
            bl = tokenManager.isMechanismFeatureSupported(mechanismArray, mechanismInfoArray);
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }

    protected abstract void a(iaik.pkcs.pkcs11.objects.Key var1);

    protected abstract void b(iaik.pkcs.pkcs11.objects.Key var1);

    protected void engineInit(Key key, SecureRandom secureRandom) {
        key = IAIKPkcs11.getGlobalKeyHandler().handleKeyAgreementKey(this.b(), key, null);
        if (key instanceof IAIKPKCS11Key) {
            this.a(key, secureRandom);
            this.n = false;
        } else if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            if (this.o == null) {
                this.h();
            }
            this.o.init(key, secureRandom);
            this.n = true;
        } else {
            throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        }
    }

    protected void e() {
        try {
            if (this.f == null) {
                Session session = this.f = this.g.isUseROSession() ? this.e.getSession(false) : this.e.getSession(true);
            }
            if (this.g.isUseUserSession()) {
                this.e.makeAuthorizedSession(this.f, null);
            }
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected void f() {
        this.e();
        this.j = true;
    }

    protected void g() {
        this.j = false;
        this.e.disposeSession(this.f);
        this.f = null;
    }

    protected void h() {
        DelegateProvider delegateProvider = this.e != null ? this.e.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        String string = this.b();
        this.o = delegateProvider.getKeyAgreement(string);
        if (this.o == null) {
            throw new IAIKPkcs11Exception("Could not get delegate key agreement engine for " + string);
        }
    }

    protected abstract String b();

    protected void a(Key key, SecureRandom secureRandom) {
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (!(key instanceof IAIKPKCS11Key)) {
            throw new InvalidKeyException("Argument \"key\" must be of type IAIKPKCS11Key.");
        }
        IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
        if (iAIKPkcs11 == null) {
            throw new IAIKPkcs11Exception("No IAIKPkcs11 provider available.");
        }
        this.k = (IAIKPKCS11Key)key;
        iaik.pkcs.pkcs11.objects.Key key2 = this.k.getKeyObject();
        this.a(key2);
        this.l = key2;
        this.e = iAIKPkcs11.getTokenManager();
        this.g = (PKCS11KeyAgreementSpec)new PKCS11KeyAgreementSpec(null).setUseUserRole(false);
        this.f();
        this.i = true;
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        key = IAIKPkcs11.getGlobalKeyHandler().handleKeyAgreementKey(this.b(), key, algorithmParameterSpec);
        if (key instanceof IAIKPKCS11Key) {
            this.a(key, algorithmParameterSpec, secureRandom);
            this.n = false;
        } else if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            if (this.o == null) {
                this.h();
            }
            this.o.init(key, algorithmParameterSpec, secureRandom);
            this.n = true;
        } else {
            throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        }
    }

    protected void a(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (!(key instanceof IAIKPKCS11Key)) {
            throw new InvalidKeyException("Argument \"key\" must be of type IAIKPKCS11Key.");
        }
        if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PKCS11KeyAgreementSpec)) {
            throw new InvalidAlgorithmParameterException("params must be null or instance of PKCS11KeyAgreementSpec");
        }
        this.k = (IAIKPKCS11Key)key;
        iaik.pkcs.pkcs11.objects.Key key2 = this.k.getKeyObject();
        this.a(key2);
        this.l = key2;
        this.g = (PKCS11KeyAgreementSpec)algorithmParameterSpec;
        this.e = this.g.getTokenManager();
        this.f();
        this.i = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Key engineDoPhase(Key key, boolean bl) {
        key = IAIKPkcs11.getGlobalKeyHandler().handleKeyAgreementPhaseKey(this.b(), key);
        if (!this.n) return this.a(key, bl);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        return this.o.doPhase(key, bl);
    }

    protected Key a(Key key, boolean bl) {
        if (!this.i) {
            throw new IllegalStateException("Key agreement not initialized!");
        }
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (!(key instanceof IAIKPKCS11Key)) {
            throw new InvalidKeyException("Argument \"key\" must be of type IAIKPKCS11Key.");
        }
        if (!bl) {
            throw new IllegalStateException("Multiple phases are unsupported");
        }
        this.m = (IAIKPKCS11Key)key;
        this.b(this.m.getKeyObject());
        this.h = true;
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineGenerateSecret() {
        if (!this.n) return this.i();
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.o.generateSecret();
    }

    protected byte[] i() {
        if (!this.i) {
            throw new IllegalStateException("Key agreement not initialized!");
        }
        iaik.pkcs.pkcs11.objects.Key key = this.a((String)null, false);
        Hashtable hashtable = key.getAttributeTable();
        ByteArrayAttribute byteArrayAttribute = (ByteArrayAttribute)hashtable.get(Attribute.VALUE);
        byte[] byArray = byteArrayAttribute != null && byteArrayAttribute.isPresent() && !byteArrayAttribute.isSensitive() ? byteArrayAttribute.getByteArrayValue() : null;
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int engineGenerateSecret(byte[] byArray, int n) {
        if (!this.n) return this.a(byArray, n);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.o.generateSecret(byArray, n);
    }

    protected int a(byte[] byArray, int n) {
        byte[] byArray2 = this.engineGenerateSecret();
        int n2 = -1;
        if (byArray2 != null) {
            n2 = byArray2.length;
            if (byArray == null) {
                throw new NullPointerException("Argument \"sharedSecret\" must not be null.");
            }
            if (n2 > byArray.length - n) {
                throw new ShortBufferException("Buffer too small. Bytes available: " + (byArray.length - n) + ", bytes needed: " + n2);
            }
            System.arraycopy(byArray2, 0, byArray, n, n2);
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected javax.crypto.SecretKey engineGenerateSecret(String string) {
        if (!this.n) return this.b(string);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        return this.o.generateSecret(string);
    }

    protected javax.crypto.SecretKey b(String string) {
        IAIKPKCS11SecretKey iAIKPKCS11SecretKey;
        if (!this.i) {
            throw new IllegalStateException("Key agreement not initialized!");
        }
        iaik.pkcs.pkcs11.objects.Key key = this.a(string, true);
        if (key instanceof SecretKey) {
            iAIKPKCS11SecretKey = IAIKPKCS11SecretKey.create(this.e, (SecretKey)key);
            if (!key.getToken().getBooleanValue().booleanValue()) {
                iAIKPKCS11SecretKey.setSession(this.f);
                this.f = null;
                this.j = false;
            }
        } else {
            this.g();
            throw new IAIKPkcs11Exception("Expected a secret key, key derivation returned key: " + key);
        }
        this.e.notifyKeyStores();
        return iAIKPKCS11SecretKey;
    }

    iaik.pkcs.pkcs11.objects.Key a(String string, boolean bl) {
        Mechanism mechanism = this.c();
        iaik.pkcs.pkcs11.objects.Key key = null;
        if (this.g != null) {
            key = this.g.getKeyTemplate();
        }
        if (key == null) {
            SecretKey secretKey = this.c(string);
            secretKey.getSensitive().setBooleanValue(new Boolean(bl));
            secretKey.getToken().setBooleanValue(Boolean.FALSE);
            secretKey.getPrivate().setBooleanValue(Boolean.TRUE);
            key = secretKey;
        }
        try {
            return this.f.deriveKey(mechanism, this.l, key);
        }
        catch (TokenException tokenException) {
            this.g();
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected abstract Mechanism c();

    protected abstract int c(iaik.pkcs.pkcs11.objects.Key var1);

    SecretKey c(String string) {
        if (string == null || string.equals("")) {
            GenericSecretKey genericSecretKey = new GenericSecretKey();
            genericSecretKey.getValueLen().setLongValue(new Long(this.c(this.m.getKeyObject())));
            return genericSecretKey;
        }
        if (string.equalsIgnoreCase("AES")) {
            AESSecretKey aESSecretKey = new AESSecretKey();
            aESSecretKey.getValueLen().setLongValue(new Long(16L));
            return aESSecretKey;
        }
        if (string.equalsIgnoreCase("DESede")) {
            DES3SecretKey dES3SecretKey = new DES3SecretKey();
            return dES3SecretKey;
        }
        if (string.equalsIgnoreCase("RC4")) {
            RC4SecretKey rC4SecretKey = new RC4SecretKey();
            rC4SecretKey.getValueLen().setLongValue(new Long(16L));
            return rC4SecretKey;
        }
        if (string.equalsIgnoreCase("DES")) {
            DESSecretKey dESSecretKey = new DESSecretKey();
            return dESSecretKey;
        }
        if (string.equalsIgnoreCase("IDEA")) {
            IDEASecretKey iDEASecretKey = new IDEASecretKey();
            return iDEASecretKey;
        }
        if (string.equalsIgnoreCase("RC2")) {
            RC2SecretKey rC2SecretKey = new RC2SecretKey();
            rC2SecretKey.getValueLen().setLongValue(new Long(16L));
            return rC2SecretKey;
        }
        if (string.equalsIgnoreCase("RC5")) {
            RC5SecretKey rC5SecretKey = new RC5SecretKey();
            rC5SecretKey.getValueLen().setLongValue(new Long(16L));
            return rC5SecretKey;
        }
        if (string.equalsIgnoreCase("BLOWFISH")) {
            BlowfishSecretKey blowfishSecretKey = new BlowfishSecretKey();
            blowfishSecretKey.getValueLen().setLongValue(new Long(16L));
            return blowfishSecretKey;
        }
        if (string.equalsIgnoreCase("TWOFISH")) {
            TwofishSecretKey twofishSecretKey = new TwofishSecretKey();
            twofishSecretKey.getValueLen().setLongValue(new Long(16L));
            return twofishSecretKey;
        }
        if (string.equalsIgnoreCase("CAST128") || string.equalsIgnoreCase("CAST5")) {
            CAST128SecretKey cAST128SecretKey = new CAST128SecretKey();
            cAST128SecretKey.getValueLen().setLongValue(new Long(16L));
            return cAST128SecretKey;
        }
        if (string.equalsIgnoreCase("CAST3")) {
            CAST3SecretKey cAST3SecretKey = new CAST3SecretKey();
            cAST3SecretKey.getValueLen().setLongValue(new Long(8L));
            return cAST3SecretKey;
        }
        if (string.equalsIgnoreCase("CAST")) {
            CASTSecretKey cASTSecretKey = new CASTSecretKey();
            cASTSecretKey.getValueLen().setLongValue(new Long(8L));
            return cASTSecretKey;
        }
        GenericSecretKey genericSecretKey = new GenericSecretKey();
        genericSecretKey.getValueLen().setLongValue(new Long(this.c(this.m.getKeyObject())));
        return genericSecretKey;
    }

    protected void finalize() {
        if (this.f != null) {
            this.g();
        }
        super.finalize();
    }
}

