/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyfactories;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.SessionInfo;
import iaik.pkcs.pkcs11.State;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public abstract class PKCS11KeyFactory
extends KeyFactorySpi
implements PKCS11EngineClass {
    public static final int PKCS8_VERSION = 0;
    protected TokenManager h;
    protected Session i;
    protected boolean j;
    protected PKCS11KeySpec k;
    protected KeyFactory l;

    public boolean isSupportedBy(TokenManager tokenManager) {
        return true;
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) {
        PublicKey publicKey;
        keySpec = IAIKPkcs11.getGlobalKeyHandler().handleKeyFactoryGeneratePublic(this.b(), keySpec);
        if (keySpec instanceof PKCS11KeySpec) {
            publicKey = this.a(keySpec);
        } else {
            if (this.l == null) {
                this.g();
            }
            publicKey = this.l.generatePublic(keySpec);
        }
        return publicKey;
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) {
        PrivateKey privateKey;
        keySpec = IAIKPkcs11.getGlobalKeyHandler().handleKeyFactoryGeneratePrivate(this.b(), keySpec);
        if (keySpec instanceof PKCS11KeySpec) {
            privateKey = this.b(keySpec);
        } else {
            if (this.l == null) {
                this.g();
            }
            privateKey = this.l.generatePrivate(keySpec);
        }
        return privateKey;
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) {
        KeySpec keySpec;
        if (key instanceof IAIKPKCS11Key) {
            keySpec = this.a(key, clazz);
        } else {
            if (this.l == null) {
                this.g();
            }
            keySpec = this.l.getKeySpec(key, clazz);
        }
        return keySpec;
    }

    protected Key engineTranslateKey(Key key) {
        Key key2;
        key = IAIKPkcs11.getGlobalKeyHandler().handleKeyFactoryTranslateKey(this.b(), key);
        if (key instanceof IAIKPKCS11Key) {
            key2 = this.a(key);
        } else {
            if (this.l == null) {
                this.g();
            }
            key2 = this.l.translateKey(key);
        }
        return key2;
    }

    protected abstract String a();

    protected abstract String b();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void d() {
        if (this.k == null) throw new IAIKPkcs11Exception("Key factory is not initialized properly. The key spec is not set appropriately.");
        this.h = this.k.getTokenManager();
        try {
            if (this.a(this.i, this.k)) return;
            if (this.i == null) {
                this.i = this.h.getSession(this.k.isUseRwSession());
            }
            if (!this.k.isUseAnonymousRole()) {
                this.h.login(this.i, this.k.isUseSORole(), this.k.getPin());
                return;
            } else {
                this.h.makeAuthorizedSession(this.i, null);
            }
            return;
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected void e() {
        this.d();
        this.j = true;
    }

    protected void f() {
        this.j = false;
        this.h.disposeSession(this.i);
        this.i = null;
    }

    protected void g() {
        DelegateProvider delegateProvider = this.h != null ? this.h.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        String string = this.a();
        this.l = delegateProvider.getKeyFactory(string);
        if (this.l == null) {
            throw new IAIKPkcs11Exception("Could not get delegate key factory engine for " + string);
        }
    }

    protected boolean a(Session session, PKCS11KeySpec pKCS11KeySpec) {
        boolean bl = false;
        if (session != null && pKCS11KeySpec != null) {
            SessionInfo sessionInfo = session.getSessionInfo();
            Token token = session.getToken();
            State state = sessionInfo.getState();
            boolean bl2 = state.equals((Object)State.RO_USER_FUNCTIONS) || state.equals((Object)State.RW_USER_FUNCTIONS);
            bl = token.equals((Object)this.h.getToken()) && sessionInfo.isRwSession() != pKCS11KeySpec.isUseROSession() && bl2 == pKCS11KeySpec.isUseUserSession();
        }
        return bl;
    }

    protected Key a(iaik.pkcs.pkcs11.objects.Object object) {
        this.e();
        iaik.pkcs.pkcs11.objects.Key key = null;
        try {
            key = (iaik.pkcs.pkcs11.objects.Key)this.i.createObject(object);
        }
        catch (TokenException tokenException) {
            this.f();
            throw new InvalidKeySpecException("Key could not be generated using the given key spec: " + tokenException.toString());
        }
        IAIKPKCS11Key iAIKPKCS11Key = IAIKPKCS11Key.create(this.h, key);
        if (!key.getToken().getBooleanValue().booleanValue()) {
            iAIKPKCS11Key.setSession(this.i);
        }
        this.f();
        this.h.notifyKeyStores();
        return iAIKPKCS11Key;
    }

    protected abstract PublicKey a(KeySpec var1);

    protected abstract PrivateKey b(KeySpec var1);

    protected abstract KeySpec a(Key var1, Class var2);

    protected Key a(Key key) {
        return key;
    }

    protected void finalize() {
        if (this.i != null) {
            this.h.disposeSession(this.i);
        }
        super.finalize();
    }
}

